/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.integration;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_5321;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import ru.bclib.BCLib;
import ru.bclib.api.tag.TagAPI;
import ru.bclib.world.features.BCLFeature;

public abstract class ModIntegration {
    private final String modID;

    public void init() {
    }

    public ModIntegration(String modID) {
        this.modID = modID;
    }

    public class_2960 getID(String name) {
        return new class_2960(this.modID, name);
    }

    public class_5321<class_6796> getFeatureKey(String name) {
        return class_5321.method_29179((class_5321)class_2378.field_35758, (class_2960)this.getID(name));
    }

    public class_2248 getBlock(String name) {
        return (class_2248)class_2378.field_11146.method_10223(this.getID(name));
    }

    public class_1792 getItem(String name) {
        return (class_1792)class_2378.field_11142.method_10223(this.getID(name));
    }

    public class_2680 getDefaultState(String name) {
        return this.getBlock(name).method_9564();
    }

    public class_5321<class_1959> getKey(String name) {
        return class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)this.getID(name));
    }

    public boolean modIsInstalled() {
        return FabricLoader.getInstance().isModLoaded(this.modID);
    }

    public BCLFeature getFeature(String featureID, String placedFeatureID, class_2893.class_2895 featureStep) {
        class_2960 id = this.getID(featureID);
        class_3031 feature = (class_3031)class_2378.field_11138.method_10223(id);
        class_6880 featurePlaced = class_5458.field_35761.method_40264(this.getFeatureKey(placedFeatureID)).orElse(null);
        return new BCLFeature(id, feature, featureStep, (class_6880<class_6796>)featurePlaced);
    }

    public BCLFeature getFeature(String name, class_2893.class_2895 featureStep) {
        return this.getFeature(name, name, featureStep);
    }

    public class_2975<?, ?> getConfiguredFeature(String name) {
        return (class_2975)class_5458.field_25929.method_10223(this.getID(name));
    }

    public class_6880<class_1959> getBiome(String name) {
        return (class_6880)class_5458.field_25933.method_40264(this.getKey(name)).orElseThrow();
    }

    public Class<?> getClass(String path) {
        Class<?> cl;
        block2: {
            cl = null;
            try {
                cl = Class.forName(path);
            }
            catch (ClassNotFoundException e) {
                BCLib.LOGGER.error(e.getMessage());
                if (!BCLib.isDevEnvironment()) break block2;
                e.printStackTrace();
            }
        }
        return cl;
    }

    public <T> T getStaticFieldValue(Class<?> cl, String name) {
        if (cl != null) {
            try {
                Field field = cl.getDeclaredField(name);
                if (field != null) {
                    return (T)field.get(null);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object getFieldValue(Class<?> cl, String name, Object classInstance) {
        if (cl != null) {
            try {
                Field field = cl.getDeclaredField(name);
                if (field != null) {
                    return field.get(classInstance);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Method getMethod(Class<?> cl, String functionName, Class<?> ... args) {
        block3: {
            if (cl != null) {
                try {
                    return cl.getMethod(functionName, args);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Object executeMethod(Object instance, Method method, Object ... args) {
        block3: {
            if (method != null) {
                try {
                    return method.invoke(instance, args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) break block3;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Object getAndExecuteStatic(Class<?> cl, String functionName, Object ... args) {
        if (cl != null) {
            Class[] classes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classes[i] = args[i].getClass();
            }
            Method method = this.getMethod(cl, functionName, classes);
            return this.executeMethod(null, method, args);
        }
        return null;
    }

    public <T> T getAndExecuteRuntime(Class<?> cl, Object instance, String functionName, Object ... args) {
        if (instance != null) {
            Class[] classes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                classes[i] = args[i].getClass();
            }
            Method method = this.getMethod(cl, functionName, classes);
            return (T)this.executeMethod(instance, method, args);
        }
        return null;
    }

    public Object newInstance(Class<?> cl, Object ... args) {
        if (cl != null) {
            for (Constructor<?> constructor : cl.getConstructors()) {
                if (constructor.getParameterCount() != args.length) continue;
                try {
                    return constructor.newInstance(args);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    BCLib.LOGGER.error(e.getMessage());
                    if (!BCLib.isDevEnvironment()) continue;
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public class_6862<class_1792> getItemTag(String name) {
        class_2960 id = this.getID(name);
        return TagAPI.makeItemTag(id);
    }

    public class_6862<class_2248> getBlockTag(String name) {
        class_2960 id = this.getID(name);
        return TagAPI.makeBlockTag(id);
    }
}

